<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use App\Mail\AkunDisetujuiMail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class UserController extends Controller
{
    public function index()
    {
        $user = User::all();
        return view('admin.user.index', compact('user'));
    }

    public function store(Request $request)
    {
        try {
            $request->validate([
                'nama'     => 'required|',
                'email'    => 'required|',
                'password' => 'required|',
                'role'     => 'required|',
                'status'   => 'required|',
            ]);

            User::create([
                'nama'     => $request->nama,
                'email'    => $request->email,
                'password' => Hash::make($request->password),
                'role'     => $request->role,
                'status'   => $request->status,
            ]);

            return redirect()->back()->with('success', 'User berhasil ditambahkan');

        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Gagal menambahkan user!');
        }
    }

    public function update(Request $request, User $user)
    {
        try {
            $request->validate([
                'nama'   => 'required',
                'email'  => 'required',
                'role'   => 'required|',
                'status' => 'required|',
            ]);

            $user->update([
                'nama'   => $request->nama,
                'email'  => $request->email,
                'role'   => $request->role,
                'status' => $request->status,
            ]);

            return redirect()->back()->with('success', 'User berhasil diperbarui');

        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Gagal memperbarui user!');
        }
    }

    public function destroy(User $user)
    {
        try {
            $user->delete();
            return redirect()->back()->with('success', 'User berhasil dihapus');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'User gagal dihapus');
        }
    }

    public function approval()
    {
        $users = User::where('role', 'karyawan')
                    ->where('status', 'pending')
                    ->latest()
                    ->get();

        return view('admin.user.approval', compact('users'));
    }


    public function approve(User $user)
    {
        if ($user->status !== 'pending') {
            return back()->with('error', 'User sudah diproses.');
        }

        $user->status = 'aktif';
        $user->save();

        // KIRIM EMAIL
        // Mail::to($user->email)->send(new AkunDisetujuiMail($user));

        return back()->with('success', 'Karyawan berhasil di-ACC & email dikirim.');
    }


    public function reject(User $user)
    {
        if ($user->status !== 'pending') {
            return back()->with('error', 'User sudah diproses.');
        }

        $user->delete();

        return back()->with('success', 'Pendaftaran karyawan ditolak.');
    }

}
